package com.icetech.basics.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 安卓app管理
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-04-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_apk_version")
public class ApkVersion implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * apk名称
     */
    private String apkName;

    /**
     * apk版本
     */
    private String apkVersion;

    /**
     * apk存储地址
     */
    private String apkPath;

    /**
     * 备注
     */
    private String remark;
    /**
     * 返回list的
     */
    @TableField(exist=false)
    private List<String> remarks;

    /**
     * 是否可用1=可以0=不可以
     */
    private Boolean active;
    /**
     * 是否强制更新
     */
    private Boolean forceUpdate;

    private Date createTime;


}
