package com.icetech.basics.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wanggang
 * @create 2021-11-01 15:51
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class SendMessage implements Serializable {


    /**
     * 类型:1端云;2端网云
     */
    private String type;

    private List<Describe> describes = new ArrayList<>();

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    @Builder
    public static class Describe implements Serializable {

        /**
         * 失败类型
         */
        private String failType;

        /**
         * 设备序列号
         */
        private List<String> serialNumbers;

        /**
         * 通讯协议版本号
         */
        private List<String> versions;

        /**
         * 固定显示
         */
        private String fixedDisplay;

    }
}
