package com.icetech.basics.constants;


import com.alibaba.fastjson.JSON;
import com.icetech.basics.domain.SendMessage;

import java.util.Collections;

/**
 * @author wanggang
 * @create 2021-10-29 13:43
 */
public class TextConstant {

    /**
     * 端云标识
     */
    public static final String ONE = "1";

    /**
     * 端网云标识
     */
    public static final String TWO = "2";
    /**
     * 端网云标识
     */
    public static final String THREE = "3";

    /**
     * 数据下发失败状态码
     */
    public static final String ERROR_410 = "410";

    /**
     * 默认key如果是10000直接展示failType
     */
    public static final String DEFAULT = "10000";

    /**
     * 月卡未到生效时间
     */
    public static final String MOOD_TAKE_EFFECT_TIME = "10001";

    /**
     * 月卡未到暂停时间
     */
    public static final String MOOD_SUSPEND_TIME = "10002";


    /**
     * 相机不在线
     */
    public static final String CAMERA_OFF_LINE = "10003";

    /**
     * 响应超时,下发失败
     */
    public static final String TIME_OUT_SEND_FAIL = "10004";


    /**
     * 相机版本过低
     */
    public static final String CAMERA_VERSION_LOW = "10005";

    /**
     * 未建立连接
     */
    public static final String UN_ESTABLISH_CONNECTION = "10006";


    /**
     * 相机空间不足
     */
    public static final String CAMERA_INSUFFICIENT_SPACE = "10007";


    /**
     * 无效参数
     */
    public static final String INVALID_PARAM = "10008";


    /**
     * 相机失败
     */
    public static final String CAMERA_ERROR = "10009";

    /**
     * 端网云下发失败
     * @return
     */
    public static String getUnEstablishConnection() {
        return JSON.toJSONString(SendMessage.builder()
                .type(TWO)
                .describes(Collections.singletonList(SendMessage.Describe.builder()
                        .failType(UN_ESTABLISH_CONNECTION)
                        .build()))
                .build());
    }

    public static String getVersionMessage(String currentVersion, String newVersion) {
        return JSON.toJSONString(SendMessage.builder()
                .type(TWO)
                .describes(Collections.singletonList(SendMessage.Describe.builder()
                        .failType(DEFAULT)
                        .fixedDisplay("本地计费系统版本过低" + currentVersion + "请将版本升级到" + newVersion + "版本以上，云平台会后会自动下发" )
                        .build()))
                .build());
    }


    public static String getDefaultMessage(String type, String message) {
        return JSON.toJSONString(SendMessage.builder()
                .type(type)
                .describes(Collections.singletonList(SendMessage.Describe.builder()
                        .failType(DEFAULT)
                        .fixedDisplay(message)
                        .build()))
                .build());
    }

    public static String getSuccessDefaultMessage(String type) {
        return JSON.toJSONString(SendMessage.builder()
                .type(type)
                .build());
    }



}
