package com.icetech.basics.constants;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum ParkDeviceTypeEnum {
    SUPER_BOX(0, "超级盒子"),
    /**
     * <pre>
     * 摄像头
     * 识别相机
     * </pre>
     */
    CAMERA(1, "摄像头"),
    GATE(2, "道闸"),
    SCREEN(3, "显示屏"),
    INTERCOM(4, "语音对讲机"),
    SMART_ROBOT(5, "智能机器人"),
    MONITOR_CAMERA(6, "监控相机"),
    /**
     * <pre>
     * 语音对讲反扫设备
     * 对讲缴费终端
     * </pre>
     */
    INTERCOM_COLUMN(7, "语音对讲反扫设备"),
    SMART_TERMINAL(8, "智能终端"),
    /**
     * <pre>
     * 华夏通道监控相机
     * 知位追缴分析摄像机
     * </pre>
     */
    HX_MONITOR(9, "华夏通道监控相机"),
    ;
    final Integer type;
    final String desc;

    private static final Map<Integer, ParkDeviceTypeEnum> TYPE_MAP = Stream.of(ParkDeviceTypeEnum.values()).collect(Collectors.toMap(ParkDeviceTypeEnum::getType, Function.identity()));
    public static ParkDeviceTypeEnum ofType(Integer type) {
        if (type == null) return null;
        return TYPE_MAP.get(type);
    }

    public static String getTypeDesc(int type) {
        ParkDeviceTypeEnum typeEnum = ofType(type);
        return typeEnum == null ? null : typeEnum.getDesc();
    }
}
