package com.icetech.basics.api;

import com.icetech.basics.domain.dto.DictionaryItemDto;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

public interface DictionaryItemService {
    /**
     * 获取开闸原因表
     * @param type 1= 入口 2- 出口
     * @return
     */
    ObjectResponse<List<DictionaryItemDto>> getOpenReasonList(Integer type);
    /**
     * 根据typeid获取列表
     * @return
     */
    ObjectResponse<List<DictionaryItemDto>> findListByTypeId(Integer typeId);

    /**
     * 查询单个记录
     * @param typeId 必传
     * @param text 和 value，二选一
     * @param value 和 text，二选一
     * @return
     */
    ObjectResponse<DictionaryItemDto> findOneItem(Integer typeId, String text, Integer value);
}
