package com.icetech.basics.api;

import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.basics.domain.request.BlacklistBatchDeleteParam;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.db.mybatis.base.service.IBaseService;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 黑名单操作
 * @author wangzw
 */
public interface BlacklistService extends IBaseService<Blacklist> {
    /**
     * 根据id查询
     * @param id
     * @return
     */
    ObjectResponse<Blacklist> getById(Long id);

    /**
     * 获取有效黑名单
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<Blacklist> getValidByPlate(Long parkId, String plateNum);

    /**
     * 查询车场下的有效黑名单
     * @param parkId
     * @return
     */
    ObjectResponse<List<Blacklist>> getValidByParkId(Long parkId);
    ObjectResponse<List<Blacklist>> getValidByParkId(Long parkId, Date createTime);
    ObjectResponse<List<Blacklist>> getValidByIds(List<String> idList);

    /**
     * 根据id查询 批量查询黑名单
     * @param idList
     * @return
     */
    ObjectResponse<List<Blacklist>> getByIds(List<Long> idList);

    /**
     * 添加
     * @param blacklist 黑名单
     * @return 影响行数
     */
    ObjectResponse<Integer> addBlackList(Blacklist blacklist);

    /**
     * 根据车场ID和第三方ID查询
     * @param parkId 车场ID
     * @param thirdBlackId 第三方黑名单Id
     * @return
     */
    ObjectResponse<Blacklist> selectByParkIdAndThirdId(@Param("parkId") Long parkId, @Param("thirdBlackId") Long thirdBlackId);

    /**
     * 批量删除黑名单 批量删除黑名单
     * @param parkIds                   用车场权限 id
     * @param blacklistBatchDeleteParam 删除参数
     * @return
     */
    ObjectResponse<Void> deleteBlackList(List<Long> parkIds, BlacklistBatchDeleteParam blacklistBatchDeleteParam);

    ObjectResponse<Blacklist> addBlacklist(Blacklist blacklist);
    ObjectResponse<Boolean> updateBlacklist(Blacklist blacklist);
    ObjectResponse<Boolean> deleteBlacklistById(Long id);

    /**
     * 通过车场id和车牌号查询黑名单
     *
     * @param parkId
     * @param carNumberList
     * @return
     */
    ObjectResponse<List<Blacklist>> selectListByParkIdAndPlateNums(Long parkId, List<String> carNumberList);
}
