package com.icetech.fullcloud.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.dto.full.RequestDTO;

/**
 * 纯云参数下发
 *
 * @author wgq
 */
public interface DownMsgService {

    /**
     * 统一参数下发
     *
     * @param request     body
     * @param sn          设备通道
     * @return messageId
     */
    ObjectResponse<String> sendDownMessage(RequestDTO request, String sn);
    /**
     * 指定messageId 下发
     *
     * @param request     body
     * @param sn          设备通道
     * @param messageId   消息id
     * @return messageId
     */
    ObjectResponse<String> sendDownMessage(RequestDTO request, String sn, String messageId);
}
