package com.icetech.cloudcenter.domain.websocket;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * TODO
 *
 * @author zhangpengzhan
 * @date 2020/9/14 20:24
 * @description:
 */
@ToString
@Getter
@Setter
public class WebsocketPushData implements Serializable {
    /**
     * 记录类型（0:未知 1:进场 2:出场 3:设备 4:告警）
     */
    private Integer recordType;

    /**
     * 进场时间
     */
    private Integer enterTime;

    /**
     * 离场时间
     */
    private Integer exitTime;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    private Integer type;

    /**
     * 车型(2大型车、1小型车，默认1)
     */
    private Integer carType;
    /**
     * 设备类型
     */
    private Integer deviceStatus;

    /**
     * 通道id
     */
    private String channelId;

    /**
     * 通道代码
     */
    private String channelCode;

    /**
     * 通道类型
     */
    private Integer channelType;

    /**
     * 通道名称
     */
    private String channelName;

    /**
     * 入口位置
     */
    private String enterNo;

    /**
     * 出口位置
     */
    private String exitNo;

    /**
     * 车牌颜色
     */
    private String plateColor;

    /**
     * 出/入场事件：1车牌识别入场、2扫二维码入场
     */
    private Integer inoutEvent;

    /**
     * 出/入场操作：1自动开闸、2远程开闸、3本地开闸
     */
    private Integer inoutOpening;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 车场ID
     */
    private Long parkId;

    /**
     * 车场编码
     */
    private String parkCode;

    /**
     * 车场名称
     */
    private String parkName;


    /**
     * 总应收金额
     */
    private String totalPrice;

    /**
     * 总实收金额
     */
    private String paidPrice;

    /**
     * 总优惠金额
     */
    private String discountPrice;

    /**
     * 当前订单支付状态
     */
    private String payStatus;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 相机已开闸
     */
    private Integer opened;

    /**
     * 允许进出场
     */
    private Integer allow;

    /**
     * 是否需要支付的标识
     */
    private Integer needPay;

}
