package com.icetech.cloudcenter.domain.vo;

import com.icetech.common.utils.MapUtils;
import com.icetech.common.utils.SignTools;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.net.URLEncoder;
import java.util.Map;

/**
 * 下单
 * @Auther: fangct
 * @Date: 2019/12/23
 * @Description:
 */
@Data
@Slf4j
public class UnifiedOrderVo {
    private static final String KEY = "56456f3ad1fa3f";
    private String parkCode;
    private String orderNum;
    private String tradeNo;
    private String spbillCreateIp;
    private String openId;
    private String userId;
    private Integer payWay;
    private String unpayPrice;
    private String plateNum;
    private String selectTradeType;
    private String channelId;
    private String sign;
    private Long enterTime;
    private String retUrl;
    private String version;

    public String createLinkStr(){
        try {
            String plateNum = URLEncoder.encode(this.plateNum, "utf-8");
            Map<String, Object> stringObjectMap = SignTools.convertMap(this);
            stringObjectMap.put("plateNum", plateNum);
            stringObjectMap.remove("spbillCreateIp");
            return MapUtils.toSortedUrlParam(stringObjectMap);
        } catch (Exception e) {
            log.error(String.valueOf(e.getMessage()), e);
            return null;
        }
    }
    public boolean verifySign(){
        try {
            String backup = this.spbillCreateIp;
            this.setSpbillCreateIp(null);
            boolean res = SignTools.verifyMD5Sign(this, KEY);
            this.setSpbillCreateIp(backup);
            return res;
        } catch (Exception e) {
            return false;
        }
    }
    public void setSign(){
        try {
            String backup = this.spbillCreateIp;
            this.setSpbillCreateIp(null);
            String sign = SignTools.sign(this, KEY);
            this.setSign(sign);
            this.setSpbillCreateIp(backup);
        } catch (Exception e) {
            this.setSign(null);
        }
    }

}
