package com.icetech.cloudcenter.domain.vo;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * @Auther: lisc
 * @Date: 2018/9/27 14:09
 * @Description:
 */
@Data
public class QueryOrderFeeVo implements Serializable {
    /**
     * 流水号
     */
    private String tradeNo;
    /**
     * 订单号
     */
    private String orderNum;
    /**
     * 总金额
     */
    private String totalAmount;
    /**
     * 已付金额
     */
    private String paidAmount;
    /**
     * 已优惠金额
     */
    private String discountAmount;
    /**
     * 优惠金额 还没用掉
     */
    private String discountPrice;
    /**
     * 需要支付金额
     */
    private String unpayPrice;
    /**
     * 停车时长
     */
    private String parkTime;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 停车场开始计费时间
     */
    private Date queryTime;
    /**
     * 停车场名称
     */
    private String parkName;
    /**
     * 车牌
     */
    private String plateNum;
    /**
     * 状态
     */
    private Integer status;
    /**
     * 车辆入场时间
     */
    private Date enterTime;
    /**
     * 超时时间是当前时间减上次支付时间
     */
    private String timeOutLength;

    /**
     * 超时时间(分钟)
     */
    private Long freeTime;

    private Double unpayDouble;

    /**
     * 支付
     */
    private String payInfo;

    /**
     * 下单类型
     */
    private String selectTradeType;
    /**
     * 下单参数
     */
    private String unifiedOrderVoLinkStr;

    /**
     * 下单完成后的完成地址
     */
    private String retUrl;


    //免费时间到
    public Date getFreeDate() {
        if (freeTime == null) {
            freeTime = 0L;
        }
        try {
            Date date = DateUtils.addMinutes(payTime, freeTime.intValue());
            return date;
        } catch (Exception e) {
            return new Date();
        }
    }

    public String getShouldPrice() {
        if (StringUtils.isBlank(unpayPrice)) {
            unpayPrice = "0.00";
        }
        if (StringUtils.isBlank(discountPrice)) {
            discountPrice = "0.00";
        }
        BigDecimal shouldBigDecimal = new BigDecimal(unpayPrice).add(new BigDecimal(discountPrice));
        String s = shouldBigDecimal.toString();
        return shouldBigDecimal.setScale(2, RoundingMode.FLOOR).toString();
    }

    public String getTotalAmount() {
        if (StringUtils.isBlank(totalAmount)) {
            totalAmount = "0.00";
        }
        return new BigDecimal(totalAmount).setScale(2, RoundingMode.FLOOR).toString();
    }

    public String getPaidAmount() {
        if (StringUtils.isBlank(paidAmount)) {
            paidAmount = "0.00";
        }
        return new BigDecimal(paidAmount).setScale(2, RoundingMode.FLOOR).toString();
    }

    public String getDiscountAmount() {
        if (StringUtils.isBlank(discountAmount)) {
            discountAmount = "0.00";
        }
        return new BigDecimal(discountAmount).setScale(2, RoundingMode.FLOOR).toString();
    }

    public String getDiscountPrice() {
        if (StringUtils.isBlank(discountPrice)) {
            discountPrice = "0.00";
        }
        return new BigDecimal(discountPrice).setScale(2, RoundingMode.FLOOR).toString();
    }

    /**
     * 获取所有的优惠金额
     *
     * @return
     */
    public String getAllDiscountAmount() {
        if (StringUtils.isBlank(discountAmount)) {
            discountAmount = "0.00";
        }
        if (StringUtils.isBlank(discountPrice)) {
            discountPrice = "0.00";
        }
        BigDecimal decimal1 = new BigDecimal(discountPrice);
        BigDecimal decimal2 = new BigDecimal(discountAmount);
        return decimal1.add(decimal2).setScale(2, RoundingMode.FLOOR).toString();
    }

    public String getUnpayPrice() {
        if (StringUtils.isBlank(unpayPrice)) {
            unpayPrice = "0.00";
        }
        return new BigDecimal(unpayPrice).setScale(2, RoundingMode.FLOOR).toString();
    }

    public Double getUnpayDouble() {
        return Double.parseDouble(this.unpayPrice);
    }

}
