package com.icetech.cloudcenter.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Description ParkTrusteeshipVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/6/28 15:44
 */
@Data
public class ParkTrusteeshipVo implements Serializable {

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 通道数量
     */
    private Integer channelNum;

    /**
     * 托管模式：1-甲方自建坐席托管，2-知位自营坐席托管
     */
    private Integer trusteeshipModel;

    /**
     * 托管价格 元 / 单通道.月 ）
     */
    private BigDecimal unitPrice;

    /**
     * 托管时长（月）
     */
    private Integer duration;

    /**
     * 有效开始日期, yyyy-MM-dd HH:mm
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date startTime;

    /**
     * 有效结束日期, yyyy-MM-dd HH:mm
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endTime;

    /**
     * 服务费支付金额
     */
    private BigDecimal payAmount;

    /**
     * 支付方式，1-现金，2-微信，3-支付宝
     */
    private Integer payMethod;

    /**
     * 缴费类型，1-开通托管服务，2-托管续费
     */
    private Integer payType;

    /**
     * 云坐席sip号
     */
    private String sipNum;

    /**
     * 是否开通延期提醒
     */
    private Integer openWarn;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 临近到期提醒天数
     */
    private Integer nearExpireDay;

    /**
     * 过期提醒天数
     */
    private Integer expireDay;

    /**
     * 操作人
     */
    private String operator;
}
