package com.icetech.cloudcenter.domain.vo;

import com.icetech.basics.domain.entity.device.ParkDevice;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * Description ParkDeviceVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/8/3 11:25 上午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ParkDeviceVo extends ParkDevice implements Serializable {

    /**
     * 通道编码
     */
    private String aisleCode;

    /**
     *通道名称
     */
    private String aisleName;

    /**
     * 通道类型
     */
    private Integer aisleType;

    /**
     * 车场编码
     */
    private String parkCode;

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 托管状态,0-未开通， 1-未生效，2-托管中，3-托管到期
     */
    private Integer trusteeshipStatus;

    /**
     * 托管有效结束日期
     */
    private Date trusteeshipEndTime;
}
