package com.icetech.cloudcenter.domain.response.pnc;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-05-08 10:22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class QueryMoreMonthCarResponse implements Serializable {

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 入场时间
     */
    private Long enterTime;

    /**
     * 离场时间
     */
    private Long exitTime;

    /**
     * 状态:1在场;2离场
     */
    private Integer status;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 车辆类型:1临时车;2:月卡车;3:特殊车辆
     */
    private Integer type;
}
