package com.icetech.cloudcenter.domain.response.p2c;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 机器人对接基础参数类
 * @param <T>
 */
@ToString
@Setter
@Getter
public class P2rBaseResponse<T> implements Serializable {
	private static final long serialVersionUID = 1L;
	@NotNull
    private String messageId;
    @NotNull
    private String token;
    @NotNull
    private Integer code;
    private String msg;
    private T data;


    public static <T> P2rBaseResponse<T> success(P2rBaseRequest<?> request, T data) {
        P2rBaseResponse<T> response = success(request);
        response.setData(data);
        return response;
    }

    /**
     * 返回正确的结果
     *
     * @param request
     * @return
     */
    public static <T> P2rBaseResponse<T> success(P2rBaseRequest<?> request) {
        return instance(request, CodeEnum.成功.getCode());
    }

    /**
     * 返回正确的结果
     *
     * @param request
     * @return
     */
    public static <T> P2rBaseResponse<T> instance(P2rBaseRequest<?> request, int code) {
        return instance(request, code, CodeEnum.getMsg(code));
    }

    /**
     * 返回正确的结果
     *
     * @param request
     * @return
     */
    public static <T> P2rBaseResponse<T> instance(P2rBaseRequest<?> request, int code, String msg) {
        P2rBaseResponse<T> response = new P2rBaseResponse<>();
        response.setToken(request.getToken());
        response.setMessageId(request.getMessageId());
        response.setCode(code);
        response.setMsg(CodeEnum.getMsg(code) + "," + msg);
        return response;
    }
}
