package com.icetech.cloudcenter.domain.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

import java.io.Serializable;
import java.util.LinkedHashSet;

/**
 * 用户返回
 * @author wangzw
 */
@Data
public class SaasUserDto implements Serializable {

    private Integer id;
    /**
     * 用户名
     */
    private String username;
    /**
     * 密码
     */
    private String password;
    /**
     * 真实姓名
     */
    private String name;
    /**
     * 联系方式
     */
    private String phone;
    /**
     * 头像
     */
    private String imgUrl;
    /**
     * 登录来源，2：云岗亭小程序，3：中央收费站，4：远程监控客服坐席，5：本地坐席，6：APP，默认为2
     */
    private Integer from = 2;
    /**
     * 是否有默认通道
     */
    private Integer isDefault;
    /**
     * 用户岗位
     */
    private String userPost;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 所属机构
     */
    private int institutionId;

    /**
     * 是否开启坐席对讲服务 1是，0否 默认0
     */
    private Integer isuseSeatservice;

    /**
     * 坐席类型 1 云坐席、2 本地坐席、3 车场帮app
     */
    private Integer seatType;

    /**
     * 云坐席/本地坐席客服坐席分机号
     */
    private String seatNumber;

    /**
     * 是否为客服，1-是
     */
    private Integer isCs;

    /**
     * 客服编号
     */
    private String csCode;

    /**
     * 修改密码提示:0不用提示修改;1提示修改
     */
    private Integer updateFlag = 0;

    private LinkedHashSet<Long> permitParkIdSet;

    @Getter
    @AllArgsConstructor
    public enum RoleEnum{
        ROLE_NAME1("云岗亭管理员",1),
        ROLE_NAME2("车场管理员",2),
        ROLE_NAME3("系统管理员",3),
        ROLE_NAME4("智慧停车云坐席",4),
        ROLE_NAME5("云调试助手",5),
        ROLE_NAME6("中央收费员",6),
        ROLE_NAME8("访客管理员",7),
        ROLE_NAME7("超级管理员",0),
        ROLE_NAME9("岗亭收费员",8),
        ;
        private String roleName;
        private Integer roleType;
        public  static Integer getByRoleName(String roleName){
            for (RoleEnum roleEnum:RoleEnum.values()){
                if (roleName.equals(roleEnum.getRoleName())){
                    return roleEnum.getRoleType();
                }
            }
            return null;
        }


    }
    public  static Boolean isModify(String roleName){
        if (roleName.equals(RoleEnum.ROLE_NAME1.getRoleName())){
            return Boolean.TRUE;
        }
        if (roleName.equals(RoleEnum.ROLE_NAME2.getRoleName())){
            return Boolean.TRUE;
        }
        if (roleName.equals(RoleEnum.ROLE_NAME3.getRoleName())){
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Integer convertExTerminal(Integer from) {
        if (from == null) {
            return null;
        }
        switch (from) {
            case 2 :
                return 3;
            case 4 :
                return 1;
            case 5 :
                return 5;
            case 6 :
                return 2;
            default:
                break;
        }
        return null;
    }
}
