package com.icetech.cloudcenter.domain.response;

import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Setter
@Getter
@ToString
public class QueryOrderFeeResponse implements Serializable {
    /** 订单号 */
    protected String orderNum;
    /** 本地订单号 */
    protected String localOrderNum;
    /** 车牌号 */
    protected String plateNum;
    /** 本次停车总金额，从车辆入场至当前时间计费的总费用 */
    protected String totalAmount;
    /** 本次停车已缴金额 */
    protected String paidAmount;
    /** 本次停车已优惠金额，已使用过优惠总金额 */
    protected String discountAmount;
    /** 本次停车优惠金额，从上次支付时间至当前时间优惠金额，等于VIP优惠金额 + 第三方优惠金额 + 商户端优惠金额 */
    protected String discountPrice;
    /** 本次停车应付金额，unpayPrice + discountPrice + discountAmount + paidAmount = totalAmount */
    protected String unpayPrice;
    /**
     * VIP优惠金额
     */
    private String vipDiscountPrice;
    /**
     * 第三方优惠金额
     */
    private String thirdDiscountPrice;
    /**
     * 商户端优惠金额
     */
    private String merchantDiscountPrice;

    /** 本次停车总时长，单位秒 */
    protected Long parkTime;
    /** 本次停车最后支付时间（unix时间戳），如果没有过预缴费，则不用传 */
    protected Long payTime;
    /** 本次停车计费的时间（unix时间戳） */
    protected Long queryTime;

    /** 内区域计费信息 **/
    protected List<QueryFeeRegionDetail> insideDetails;

    /**
     * 1免费时长内无需缴费 2初次缴费 3已缴费未超时 4已缴费已超时
     */
    private Integer status;
    /** 入场时间 */
    private Long enterTime;
    private String parkName;

    /**
     * 预留免费时长
     */
    private Long freeTime;
    /**
     * 车型
     */
    private Integer carType;

    private Boolean isFixedFee;
    /**
     * 交易流水号，断电应急时必传
     */
    private String tradeNo;
    /**
     * 是否断电应急
     */
    private Boolean isOffline;
    /**
     * 内场是否有费用
     */
    private Boolean hasInnerAreaFee;

    /** 本次停车需支付金额+总共需要补缴金额 unpayPrice + totalNotPayPrice */
    private String sumPrice;

    /** 总共需要补缴金额 */
    private String totalNotPayPrice;

    /** 欠费订单列表 */
    private List<NotPayDetail> notPayDetails;

    public String getSumPrice() {
        if (this.sumPrice != null) {
            return this.sumPrice;
        }
        if (this.unpayPrice != null && this.totalNotPayPrice != null) {
            this.sumPrice = new BigDecimal(unpayPrice).add(new BigDecimal(totalNotPayPrice)).toString();
        } else if (this.unpayPrice != null) {
            this.sumPrice = this.unpayPrice;
        } else if (this.totalNotPayPrice != null) {
            this.sumPrice = this.totalNotPayPrice;
        }
        return this.sumPrice;
    }
    public Integer getStatus() {
        if (this.status != null && this.status == 1 && NumberUtils.parseDouble(getSumPrice()) > 0) {
            this.status = 2;
        }
        return this.status;
    }

    public boolean removeNotPayItem(String orderNum) {
        if (CollectionUtils.isEmpty(notPayDetails) || StringUtils.isBlank(orderNum)) {
            return false;
        }
        boolean ret = notPayDetails.removeIf(notPayDetail -> notPayDetail.getOrderNum().equals(orderNum));
        if (ret) {
            double totalNotPayPrice = notPayDetails.stream().mapToDouble(notPayDetail ->
                    NumberUtils.parseDouble(notPayDetail.getUnPayPrice())).sum();
            this.totalNotPayPrice = String.valueOf(totalNotPayPrice);
            this.sumPrice = String.valueOf(totalNotPayPrice +
                    (this.unpayPrice == null ? 0 : NumberUtils.parseDouble(this.unpayPrice)));
        }
        return ret;
    }

    /**
     * 构造空的费用结果
     * @param plateNum 车牌号
     * @param parkName 车场
     * @param freeAfterPay 预留免费时长 分钟
     * @param carType 车型
     * @param orderNum 订单号
     * @return 空的费用
     */
    public static QueryOrderFeeResponse buildEmptyOrderFee(String plateNum, String parkName,
                                                    Integer freeAfterPay, Integer carType, String orderNum) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(orderNum)) {
            queryOrderFeeResponse.setOrderNum(orderNum);
        } else {
            queryOrderFeeResponse.setOrderNum("E" + CodeTools.GenerateOrderNum());
        }
        queryOrderFeeResponse.setParkName(parkName);
        queryOrderFeeResponse.setPlateNum(plateNum);
        queryOrderFeeResponse.setEnterTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setCarType(carType);
        queryOrderFeeResponse.setQueryTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setParkTime(0L);
        queryOrderFeeResponse.setTotalAmount(String.valueOf(0));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(0));
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(1);
        queryOrderFeeResponse.setFreeTime((long) freeAfterPay);
        return queryOrderFeeResponse;
    }
}
