package com.icetech.cloudcenter.domain.response;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Getter
@Setter
@ToString
public class QueryFeeResponse implements Serializable {
    /** 订单号 */
    protected String orderId;
    /** 车牌号 */
    protected String plateNum;
    /** 总金额，从车辆入场至当前时间计费的总费用 */
    protected String totalAmount;
    /** 已缴金额 */
    protected String paidAmount;
    /** 已优惠金额，已使用过优惠总金额 */
    protected String discountAmount;
    /** 本次优惠金额，从上次支付时间至当前时间优惠金额 */
    protected String discountPrice;
    /** 本次应付金额，unpayPrice + discountPrice + discountAmount + paidAmount = totalAmount */
    protected String unpayPrice;
    /** 停车总时长，单位秒 */
    protected Long parkTime;
    /** 最后支付时间（unix时间戳），如果没有过预缴费，则不用传 */
    protected Long payTime;
    /** 计费的时间（unix时间戳） */
    protected Long queryTime;
    /** 入场时间 */
    protected Long enterTime;
    /** 内区域计费信息 **/
    protected List<QueryFeeRegionDetail> insideDetails;
    /**使用的优惠券**/
    private String discountNos;
    /**商家优惠金额**/
    private String merchantDiscountPrice;
    /**第三方优惠金额**/
    private String thirdDiscountPrice;
    /**VIP优惠金额**/
    private String vipDiscountPrice;
    /**VIP类型ID**/
    private List<Integer> vipTypeId;

    /**
     * 总欠费金额
     */
    private String totalNotPayPrice;

    /**
     * 欠费订单列表
     */
    private List<NotPayDetail> notPayDetails;
}
