package com.icetech.cloudcenter.domain.response;

import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.common.constants.PlateTypeEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class PlateTypeDto implements Serializable {

    /**
     * 车辆类型枚举
     */
    private PlateTypeEnum plateTypeEnum;
    /**
     * 描述信息
     */
    private String carDesc;

    /**
     * 是否公务车
     * @param plateNum 车牌号
     * @return 是否公务车
     */
    public static boolean officialCar(String plateNum) {
        if (StringUtils.isBlank(plateNum)) {
            return false;
        }
        if (DataCommonConstants.isNoPlate(plateNum)) {
            return false;
        }
        if (plateNum.length() < 7) {
            return false;
        }
        return plateNum.endsWith("G");
    }

}
