package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ParkVisitDto implements Serializable {

    private Long id;
    /**
     *预约记录编码(修改时候用）
     */
    private String visitNum;
    /**
     *
     */
    private Integer parkId;
    private String parkName;
    private String parkCode;
    /**
     *车牌号码（多个逗号分隔）
     */
    private String plateNums;
    /**
     *访客联系方式
     */
    private String visitPhone;
    /**
     *访客姓名
     */
    private String visitName;
    /**
     *业主姓名
     */
    private String masterName;
    /**
     *业主电话
     */
    private String masterPhone;
    /**
     *到访原因
     */
    private String reason;
    /**
     *失败原因
     */
    private String checkReason;
    /**
     *业主房号
     */
    private String masterNum;
    /**
     *预约开始时间
     */
    private String startTime;
    /**
     *预约结束时间
     */
    private String endTime;

    /**
     * 入场时间
     */
    private Integer enterTime;
    /**
     * 离场时间
     */
    private Integer exitTime;
    /**
     * 操作人
     */
    private String editer;

    /**
     * 用户id
     */
    private Integer mpUserId;
    /**
     *
     */
    private Date createTime;
    /**
     *
     */
    private Date updateTime;
    /**
     * 访客车辆审核 1人工审核2自动审核
     */
    private Integer isAuto;
    /**
     * 审核状态：1未审核,2审核通过,3审核拒绝
     */
    private Integer checkStatus;
    /**
     * 来源
     */
    private Integer from;
    /**
     * 来访者状态   1未来访/2已来访/3已出场/4已过期
     */
    private Integer visitStatus;

    /**
     * 添加人
     */
    private String adder;
    /**
     * 允许多次进出   0否 1是
     */
    private Integer inoutMore;
    /**
     * 预约车进出次数
     */
    private Integer inoutNum;
}
