package com.icetech.cloudcenter.domain.response;

import com.icetech.common.domain.Page;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * Description ParkTrusteeshipRecordPage
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/4 09:56
 */
@Data
public class ParkTrusteeshipRecordPage<T> extends Page<T> {

    /**
     * 总服务费支付金额
     */
    private BigDecimal totalPayAmount;

    public static <T> ParkTrusteeshipRecordPage<T> instance(int totalPage, long total, List<T> row, BigDecimal totalPayAmount) {
        ParkTrusteeshipRecordPage<T> page = new ParkTrusteeshipRecordPage<>();
        page.setTotalPage(totalPage);
        page.setTotal(total);
        page.setRows(row);
        page.setTotalPayAmount(totalPayAmount);
        return page;
    }
}
