package com.icetech.cloudcenter.domain.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 组织机构树
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class OrganizationTreeDto implements Serializable, Comparable<OrganizationTreeDto> {
    /**
     *机构ID
     */
    private String id;
    /**
     * 车场id
     */
    private Integer parkId;
    /**
     *显示名称
     */
    private String name;
    /**
     * 通道编号
     */
    private String aisleCode;
    /**
     *父ID
     */
    @JsonProperty("pId")
    private Integer pId;
    /**
     *类型，1：机构，2：车场
     */
    private Integer type ;
    /**
     *默认开启状态
     */
    private boolean open = true;

    @Override
    public int compareTo(OrganizationTreeDto o) {
        return this.getPId().compareTo(o.getPId());
    }
}
