package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单交易
 */
@Data
public class OrderDto implements Serializable {

    private Integer id;
    /**
     * 车场id
     */
    private Long parkId;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 支付类型(1=临停缴费,2=月卡续租)
     */
    private Integer type;


    /**
     * 车牌号(多个用,隔开)
     */
    private String plateNum;

    /**
     *支付时间
     */
    private Date payTime;

    /**
     *支付金额
     */
    private String price;


}
