package com.icetech.cloudcenter.domain.response;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 月卡开票
 * @author wangzhiwei
 */
@Setter
@Getter
@ToString
public class MpMonthInvoiceResponse implements Serializable {
    /**
     * 车场id
     */
    private Long parkId;
    private Long orderPayId;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 产品名称
     */
    private String productName;
    /**
     * 车牌号 多个,分割
     */
    private String plateNum;
    /**
     * 有效期开始时间
     */
    private String startTime;
    /**
     * 有效期结束时间
     */
    private String endTime;
    /**
     * 金额
     */
    private String totalPrice;
    /**
     * 支付时间
     */
    private Long payTime;
    /**
     * 是否允许开发票
     */
    private Boolean invoice = true;
    /**
     * 开票原因
     */
    private String reason;

}
