package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;

@Data
public class MonthProductDto implements Serializable {
    /**
     * 月卡产品id
     */
    private Long id;
    /**
     * 车场名称
     */
    private String parkName;
    private Long parkId;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 月卡产品名称
     */
    private String name;
    /**
     * 产品面额
     */
    private int duration;
    /**
     * 产品类型 适用时段1全天2分时段
     */
    private int cardType;
    /**
     * 金额
     */
    private BigDecimal paymoney;
    /**
     * 区域名称
     */
    private String regionName;
    /**
     * 审核生效
     */
    private Integer renewstatusValid;
    /**
     * 开卡生效
     */
    private Integer addstatusValid;
    /**
     * 产品有效期开始时间
     */
    private Date startDate;
    /**
     * 分时段开始时间
     */
    private Time startTime;
    /**
     * 产品有效期结束时间
     */
    private Date endDate;
    /**
     * 分时段结束时间
     */
    private Time endTime;
    /**
     *电话
     */
    private String telphone;

    /**
     * 车位数
     */
    private int plotCount;

    /**
     * 标签描述
     */
    private String tagContent;

    /**
     * 使用规则
     */
    private String userChareg;

    /**
     * 剩余月卡数量
     */
    private Integer remainMonthCards;

    /**
     * 区域名称
     */
    private String regionNames;

    /**
     * 购买须知
     */
    private String buyNotice;

    /**
     * 客服电话
     */
    private String customerServicePhone;

    /**
     * 押金
     */
    private BigDecimal deposit;

    /**
     * 是否需要有押金 默认0,0否，1是',
     */
    private Integer isHaveDeposit;
}
