package com.icetech.cloudcenter.domain.response;

import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.common.utils.DateTools;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class MonthDetailDto implements Serializable {
    private MonthInfo monthInfo;
    private MonthProduct monthProduct;
    private MonthType monthType;
    /**
     * 离场时此值为空
     */
    private MonthAbDto monthAbDto;
    private CardType cardType;
    private Integer expiredDays;
    private Integer unexpiredDays;
    private ParkRegion parkRegion;

    public void setMonthInfo(MonthInfo monthInfo) {
        this.monthInfo = monthInfo;
        if (monthInfo != null && this.monthInfo.getEndTime() != null) {
            expiredDays = DateTools.differentDaysExcludeHMS(this.monthInfo.getEndTime(), new Date());
            unexpiredDays = DateTools.differentDaysExcludeHMS(new Date(), this.monthInfo.getEndTime());
        }
    }

    public enum MonthType {
        非月卡车, 月卡车, 多位多车占用,
        /**
         * 过期的月卡不按月卡车处理时，按过期临时车
         */
        过期临时车, 过期月卡车;
    }

    public enum CardType {
        全天卡, 错时卡;
    }
}
