package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description: 月卡限制配置
 * @Author: wangzhiwei
 * @CreateTime: 2022-11-08  14:47
 * @Version: 1.0
 */
@Data
public class MonthCardConfigDto implements Serializable {
    /**
     * 公众号续费最大可购买月数，-1代表不限制
     */
    private Integer cardLimitMonths;
    /**
     * 公众号可续费的过期天数，最大365，-1代表不限制
     */
    private Integer renewCardLimitDays;
    /**
     * 公众号月卡续费开始时间要求，1：可选择开始时间，2：连续续费
     */
    private Integer renewCardStarttimeType;
}
