package com.icetech.cloudcenter.domain.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 多位多车月卡
 *
 * @author fangct
 * @date 2021/11/10
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class MonthAbDto implements Serializable {

    /**
     * 是否为多位多车月卡车
     */
    private Boolean abCar;
    /**
     * 是否为月卡车
     */
    private Boolean monthCar;
    /**
     * 车位数
     */
    private Integer plotCount;

    /**
     * 车牌数
     */
    private Integer plateNumCount;

    /**
     * AB车中的第几车
     */
    private Integer index;
}
