package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class MerchantDto implements Serializable {


    private Integer id;

    /**
     * 停车场id
     */
    private int parkId;
    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 商户号
     */
    private String code;


    /**
     * 负责人手机号
     */
    private String phone;
    /**
     * 商户名称
    */
    private String name;

    /**
     * 余额
     */
    private BigDecimal balance;

    /**
     * 登录名
     */
    private String loginName;


    /**
     * 是否可透支余额，0：否，1：是
     */
    private int overdrawFlag;

    /**
     *可透支金额
     */
    private BigDecimal overdrawAmount;

    /**
     * 用户头像
     */
    private String imgUrl;

    /**
     * 状态，0：正常，1：删除
     */
    private int status;

    /**
     * 是否支持在线充值 1=支持 0=不支持
     */
    private Integer recharge;

    /**
     * 是否支持支付
     */
    private Boolean paySupportFlag;

    /**
     * 系统自动添加 0不支持，1支持
     */
    private Integer isQrcode;

    /**
     * 静态码领取时限 1=限时 0=不限时
     */
    private Integer isLimitTime;

    /**
     * 静态码领取限制时长
     */
    private Integer limitTime;

    /**
     * 有访客车的权限，0：否，1：是
     */
    private Integer visitPrivilege;
}
