package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 发票响应参数
 * @author kate
 */
@Data
public class InvoiceResponse implements Serializable {

    private Long orderPayId;
    /**
     * 入场时间
     */
    private Long enterTime;
    /**
     * 离场时间
     */
    private Long exitTime;
    /**
     * 车场id
     */
    private Long parkId;
    /**
     * 车场编码
     */
    private String parkCode;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 支付时间
     */
    private Long payTime;
    /**
     * 金额
     */
    private String price;
    /**
     * 订单号
     */
    private String orderNo;
    /***
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 是否允许开发票
     */
    private Boolean invoice = true;
    /**
     * 开票原因
     */
    private String reason;
}
