package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;

@Data
public class ExitRecordsResponse implements Serializable {
    private String recordId;
    private String carNum;
    private String enterTime;
    private String leaveTime;
    private String enterUrl;
    private String leaveUrl;
    private String payableAmount;
    private String paidAmount;
    private Integer payMethod;
    private String refundAmount;
    private Integer exceptionCode;
    private String note;
    private Integer carType;

    /**
     * 平台支付方式与金地支付方式转换
     * @param type
     * @return
     */
    public static Integer convertLocalPayMethod(Integer type){
        if (type == 1){
            //现金
            return 9;
        }
        if (type == 2){
            //微信
            return 2;
        }
        if (type == 3){
            //支付宝
            return 5;
        }
        return 10;
    }

    /**
     * 平台车辆类型金地车辆类型转换
     * @param type
     * @return
     */
    public static Integer convertLocalCarType(Integer type){
        if (type == 1){
            //普通车
            return 3;
        }
        if (type == 2){
            //长租车
            return 1;
        }
        if (type == 3){
            //特殊车辆
            return 2;
        }
        if (type == 4){
            //vip
            return 4;
        }
        return 3;
    }

}
