package com.icetech.cloudcenter.domain.response;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 设备列表查询接口
 */
@ToString
@Setter
@Getter
public class DeviceListDTO implements Serializable{

    /**
     * 设备ID
     */
    private Long deviceId;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 所属出入口名称
     */
    private String channelName;
    /**
     *  设备序列号
     */
    private String sn;
    /**
     * 设备状态,0未连接 1在线 2离线 3故障
     */
    private Integer deviceStatus;
    /**
     * 相机协议类型，1：WS，2：阿里IOT
     */
    private Integer protocolType;
    /**
     * 产品型号
     */
    private String productModel;
    /**
     * 固件版本号
     */
    private String firmwareVersion;
    /**
     * 端云协议版本
     */
    private String protocolVer;
    /**
     * 设备IP
     */
    private String ip;
    /**
     * 是否自动切换通讯协议，0：否，1：是
     */
    private Integer isAutoSwitchProtocol;

}
