package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Data;

import java.util.List;

@Data
public class VipCarTypeRequest {
    /**
     * 操作类型1=添加 2=修改 3=删除
     */
    protected Integer operType;
    /**
     * 操作时间（unix时间戳）
     */
    protected Long operTime;
    /**
     * VIP车辆类型ID
     */
    protected Integer vipCarTypeId;
    /**
     * VIP车辆类型名称
     */
    protected String vipCarTypeName;
    /**
     * 优惠类型
     */
    protected Integer discountType;
    /**
     * 优惠数额
     */
    protected String discountNumber;
    /**
     * 计费规则编号
     */
    protected String billtypeCode;

    /**
     * VIP车辆类型所属区域 1=全车场 2=指定区域
     */
    protected Integer regionRange;

    /**
     * 各区域对应计费规则集合 当regionRange =2使用
     */
    protected List<RegionBillContent> regionBillContent;



}
