package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 端网云架构-计费规则下发参数类
 */
@ToString
@Setter
@Getter
public class PncChargeRuleRequest implements Serializable{
    private Integer billtype;
    private Integer isDefault;
    private String billtypecode;
    private String billtypename;
    private Object chargeRule;
    private Integer operType = 1;
    @ToString
    @Setter
    @Getter
    public static class NaturalDayRule{
        private Integer freetime;
        private Integer isFreetimeOnce;
        private Integer daynightmaxfeeusing;
        private Float daynightmaxfee;
        private Float daynightmaxfeeBig;
        private Integer isspecialdaycharge;
        private Integer oneBillmethod;
        private Integer isSmallbigcarSet;
        private Integer twoBillmethod;
        private Integer daynightmaxfeetype;
        private Integer daynightmaxfeecounttype;
        private Object firstConfig;
        private Object twoConfig;
        public void setDaynightmaxfeeusing(Integer daynightmaxfeeusing){
            if (daynightmaxfeeusing == null){
                daynightmaxfeeusing = 0;
            }
            this.daynightmaxfeeusing = daynightmaxfeeusing;
        }
        public Integer getDaynightmaxfeeusing(){
            if (this.daynightmaxfeeusing == null){
                this.daynightmaxfeeusing = 0;
            }
            return this.daynightmaxfeeusing;
        }
    }

    @ToString
    @Setter
    @Getter
    public static class DayNightRule{
        private Integer freetime;
        private Integer isFreetimeOnce;
        private Integer daynightmaxfeeusing;
        private Float daynightmaxfee;
        private Float daynightmaxfeeBig;
        private Integer daybegin;
        private Integer nightbegin;
        private Integer daymaxfeeusing;
        private Float daymaxfee;
        private Float daymaxfeeBig;
        private Integer nightmaxfeeusing;
        private Float nightmaxfee;
        private Float nightmaxfeeBig;
        private Integer dayBillmethod;
        private Integer nightBillmethod;
        private Integer isSmallbigcarSet;
        private Integer daynightmaxfeetype;
        private Integer daynightmaxfeecounttype;
        private Object dayConfig;
        private Object nightConfig;

        public void setDaynightmaxfeeusing(Integer daynightmaxfeeusing){
            if (daynightmaxfeeusing == null){
                daynightmaxfeeusing = 0;
            }
            this.daynightmaxfeeusing = daynightmaxfeeusing;
        }
        public Integer getDaynightmaxfeeusing(){
            if (this.daynightmaxfeeusing == null){
                this.daynightmaxfeeusing = 0;
            }
            return this.daynightmaxfeeusing;
        }
        public Integer getDaymaxfeeusing(){
            if (this.daymaxfeeusing == null){
                this.daymaxfeeusing = 2;
            }
            return this.daymaxfeeusing;
        }
        public void setDaymaxfeeusing(Integer daymaxfeeusing){
            if (daymaxfeeusing == null){
                daymaxfeeusing = 2;
            }
            this.daymaxfeeusing = daymaxfeeusing;
        }
        public void setNightmaxfeeusing(Integer nightmaxfeeusing){
            if (nightmaxfeeusing == null){
                nightmaxfeeusing = 2;
            }
            this.nightmaxfeeusing = nightmaxfeeusing;
        }
        public Integer getNightmaxfeeusing(){
            if (this.nightmaxfeeusing == null){
                this.nightmaxfeeusing = 2;
            }
            return this.nightmaxfeeusing;
        }
    }
    @ToString
    @Setter
    @Getter
    public static class Charge24Rule{
        private Integer freetime;
        private Integer isFreetimeOnce;
        private Integer daynightmaxfeeusing;
        private Float daynightmaxfee;
        private Float daynightmaxfeeBig;
        private Integer divisionTime;
        private Integer isOverTimeSet;
        private Integer feespantimestep;
        private Float feespanratestep;
        private Integer isSmallbigcarSet;
        private Float feespanratestepBig;
        private Integer daynightmaxfeetype;
        private Integer daynightmaxfeecounttype;
        private List<Charge24RuleDetail> details;

        public void setIsOverTimeSet(Integer isOverTimeSet){
            if (isOverTimeSet == null){
                isOverTimeSet = 2;
            }
            this.isOverTimeSet = isOverTimeSet;
        }
        public Integer getIsOverTimeSet(){
            if (this.isOverTimeSet == null){
                this.isOverTimeSet = 2;
            }
            return this.isOverTimeSet;
        }
    }
    @ToString
    @Setter
    @Getter
    public static class Charge24RuleDetail{
        private Integer recordStatus;
        private Integer feespantime;
        private Float feespanrate;
        private Float feespanrateBig;

    }
    @ToString
    @Setter
    @Getter
    public static class ChargeOnce{
        private Integer isopenoncecharge;
        private Float oncechargefee;
        private Float oncechargefeeBig;
        private Integer isopenother2;
        private Integer timeFrame;
        private Float timeFrameOncefee;
        private Float timeFrameOncefeeBig;
        private Float otherTimeframeOncefee;
        private Float otherTimeframeOncefeeBig;
        private Integer isattachoption;
        private Integer overTime;
        private Float addOvernightFee;
        private Float addOvernightFeeBig;

        public void setIsopenother2(Integer isopenother2){
            if (isopenother2 == null){
                isopenother2 = 2;
            }
            this.isopenother2 = isopenother2;
        }
        public Integer getIsopenother2(){
            if (this.isopenother2 == null){
                this.isopenother2 = 2;
            }
            return this.isopenother2;
        }
        public Integer getIsattachoption(){
            if (this.isattachoption == null){
                this.isattachoption = 2;
            }
            return this.isattachoption;
        }
        public void setIsattachoption(Integer isattachoption){
            if (isattachoption == null){
                isattachoption = 2;
            }
            this.isattachoption = isattachoption;
        }
    }
    @ToString
    @Setter
    @Getter
    public static class ChargeDyration{
        private Integer isOverTimeSet;
        private Integer overTime;
        private Integer feespantime;
        private Float feespanrate;
        private Float feespanrateBig;
        private List<StepChargeDetail> stepChargeDetails;

        public void setIsOverTimeSet(Integer isOverTimeSet){
            if (isOverTimeSet == null){
                isOverTimeSet = 2;
            }
            this.isOverTimeSet = isOverTimeSet;
        }
        public Integer getIsOverTimeSet(){
            if (this.isOverTimeSet == null){
                this.isOverTimeSet = 2;
            }
            return this.isOverTimeSet;
        }
    }
    @ToString
    @Setter
    @Getter
    public static class StepChargeDetail{
        private Integer startTimeModule;
        private Integer endTimeModule;
        private Integer feespantime;
        private Float feespanrate;
        private Float feespanrateBig;

    }
}
