package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 端网云架构车场配置
 */
@ToString
@Setter
@Getter
public class ParkConfigRequest {
    private String parkName;
    /**
     *
     */
    private Integer operType = 1;
    /**
     * 泊位总数
     */
    private Integer totalPark;
    /**
     * 空车位数
     */
    private Integer freePark;
    /**
     * 场中场切换免费时长 分钟
     */
    private Integer switchFeeTime;
    /**
     * 是否场中场（1：是，2：否）
     */
    private Integer isMidfield;
    /**
     * 免费时长是否计入停车费用1：是 2
     */
    private Integer freeTimeStatus;
    /**
     * 计费精度 0：分钟，1：秒
     */
    private Integer bilPrecision;
    /**
     * 是否补时 1是2否
     */
    private Integer isFillTime;
    /**
     * 是否抹零头1是2否
     */
    private Integer isRounding;
    /**
     * 缴费后离场预留免费时长(单位分钟)
     */
    private Integer isFreeAfterPay;
    /**
     * 超时计费起始时间1末次缴费时间 2车辆入场时间
     */
    private Integer overTimeBillType;
    /**
     * 是否允许二次使用免费时长 1不允许2允许
     */
    private Integer isAllowFreeTmonce;
    /**
     * 出场查无入场记录、支持固定收费1是2否
     */
    private Integer isFixedFee;
    /**
     * 固定收费金额 单位元 isFixedFee=1时候必填
     */
    private Integer fixedFeeValue;
    /**
     * 计费版本1：标准版 ，2：YC
     */
    private Integer billVersion = 1;
    /**
     * 是否支持电子支付 0：不支持 1：支持
     */
    private Integer isEpayMent;
    /**
     * 聚合支付支付类型 0：支付直连，1：民生银行，2：建设银行，3：农业银行，4：电子支付间联，5：阿里平台支付
     */
    private Integer epayMentType;
    /**
     * 是否支持无感支付 0：不支持 1支持
     */
    private Integer isNosenPayMent;
    /**
     * 无感支付支付类型  0：银联无感支付，1：建行无感支付，2：农行无感支付
     */
    private Integer nosenPayMentType;
    /**
     * 货币单位
     */
    private String monetaryUnit;
    /**
     * 免费时间内是否自动抬杆 0：不自动  1：自动
     */
    private Integer isReleaseFreetm;
    /**
     * 军警车是否免费停车 0：不免费 1：免费
     */
    private Integer isFreeSpecialCar;
    /**
     * 在车位满的情况下，是否禁止临时车入内，0：否 1：是
     */
    private Integer isFullForbidEnter;
    /**
     * 剩余多少空车位时，禁止入场，is_full_ forbidenter为1时不能为空
     */
    private Integer fullEmptyNum;
    /**
     * 月卡车是否计入总车位数1是 2 否
     */
    private Integer isCarDcount;
    /**
     * 访客车辆是否收费 0否 1是
     */
    private Integer visitIscharge;
    /**
     * 是否允许无牌车重复入场，0：否 1：是
     */
    private Integer isNoplateRepeatenter;
    /**
     * 是否支持多位多车管理
     */
    private Integer isMultipleVehicles = 1;
    /**
     * 多位多车场内切换时间
     */
    private Integer multipleTime = 0;
    /**
     * 多位多车收费方式1：超时场内切换，B车收取入场时间至A车出场期间的费用，2：超时场内切换，B车收取从入场到离场的全部费用
     */
    private Integer multipleBillType;
    /**
     * 是否上报车辆图片 0：不上报 1：上报
     */
    private Integer isUpImage = 1;
    /**
     * 是否同步入场数据到出口1：是，2：否
     */
    private Integer isSynDataToOut;
    /**
     * 双摄相机延时等待时长(毫秒),区间100-5000
     */
    private Integer dualCameraTime;
    /**
     * 屏显类型
     */
    private Integer screenType;
    /**
     * 控制卡型号
     */
    private Integer ctrlCardModel;
    /**
     * 是否有TTS 1：有，2：没有
     */
    private Integer isSupportTTS;
    /**
     * 是否进/出共用一个通道1：是，2：否
     */
    private Integer isInOutPass;
    /**
     * 入场到出场最小时间（秒）
     */
    private Integer enexMinTime;
    /**
     * 出场到入场最小时间（秒）
     */
    private Integer exenMinTime;

    /**
     * 省份简称
     */
    private String provinceName;
    /**
     * 优惠后离场预留免费时长（分钟）
     */
    private Integer discountFreeTime;
    /**
     * 免密支付最高限额
     */
    private Integer secretFree = 1000;

    private Integer isVisit = 1;
    /**
     * 在车位满的情况下，是否禁止月卡车入内，0：否 1：是
     */
    private Integer isFullForbidMonthEnter;
    /**
     * 在车位满的情况下，是否禁止VIP车入内，0：否 1：是
     */
    private Integer isFullForbidVIPEnter;
    /**
     * 在车位满的情况下，是否禁止预约车入内，0：否 1：是
     */
    private Integer isFullForbidReservEnter;
    /**
     * 在车位满的情况下，是否禁止储值车入内，0：否 1：是
     */
    private Integer isFullForbidStoreEnter;

    /**
     * 大型车固定收费金额 单位元 isFixedFee=1时候必填
     */
    private Integer fixedFeeValueBig;

    /**
     * 无牌车扫码校验：0：关闭，1：开启，默认1
     */
    private Integer isNocardCheck;

    /**
     * 车场类型id，多个以逗号隔开(在车位满的情况下，是否禁止VIP车入内)
     */
    private String vipCarType;

    /**
     * 在车位满的情况下，是否禁止黑名单车入内，0：否 1：是
     */
    private Integer isFullForbidBlackEnter;

    /**
     * 全免车辆重复入场，0：不允许，1：允许，默认为1
     */
    private Integer freeCarReenter;
    /**
     * 空车位计算方式
     * 1-进出场加减
     * 2-泊位总数减在场车辆
     */
    private Integer calcSpaceMethod;
    /**
     * 删除/修改离场, 余位是否更新(0/1)
     */
    private Integer delOrderCalcSpaceFlag;
    /**
     * 开启车牌号过滤 1 车场 2 道口
     */
    private Integer plateFilterType;
    /**
     * 过滤时间
     */
    private Integer filterTime;

    /**
     * 车辆出入口停留多长时间监控坐席提醒单位分
     */
    protected Integer carenexTimelong;
    /**
     * 滞留上报方式 1：一次，2：多次
     */
    protected Integer retentionAlarmMethod;
    /**
     * 滞留重复报警间隔时间，范围在5到600；滞留报警方式为多次时，此值有效
     */
    protected Integer retentionIntervalTime;
    /**
     * 滞留车辆取消时间单位分钟
     */
    protected Integer retentionCancelTime;



    /**
     * 同一车牌可获取几张优惠券 1：一张，2：多张 默认1
     */
    private Integer plateGetCoupons;

    /**
     * 优惠券支持叠加使用 1：支持，2：不支持 默认2
     */
    private Integer supportStackeUsage;


    /**
     * 第三方优惠与商户端券叠加使用 0：不支持，1：支持 默认1
     */
    private Integer thirdpartyStackeUsage;

    /**
     * 一次进出使用优惠券次数 1：一次进出，只能使用一次优惠券，2：一次进出，可多次使用优惠券 默认2（同一车牌可获取几张优惠券为多张2时有效）
     */
    private Integer userMultipleTimes;


    /**
     * 相同种类的优惠券类型：2：时长券，3：代金券，多个以逗号隔开（优惠券支持叠加使用为1（支持）时有效）
     */
    private String sametypeTogetherUser;

    /**
     * 场内办月卡收费方式，1：收取办月卡前时间段费用，2：全部停车时长免费
     */

    private Integer inparkRenewType;
    /**
     * 过期月卡场内续费有临时车空档期收费方式，1：收取临时车空档期费用，2：全部停车时长免费
     */
    private Integer timeoutRenewType;

    /**
     * 无入场权限的车辆，相机识别后记录在场，道闸不起杆 0:关闭 1:开启 默认0
     */
    private Integer deniedAddOrder;

    /**
     * 重复入场行为超过X次,再次进场后，将车辆加入黑名单
     */
    private Integer reenterBlackTime;

    /**
     * 欠费车辆入口补缴开关 0:关闭 1:开启 默认0
     */
    private Integer enterpayType;

    /**
     * 入场前需补缴N（1-30）天有欠费订单
     */
    private Integer enterpayRangeDay;

    /**
     * 车辆出口缴费，找不到车辆入场信息 处理方式 1,人工处理 2,匹配该车辆上一次入场记录计费 3,固定收费
     */
    private Integer noenterHandleType;

    /**
     * 匹配上一次入场记录的时间范围X（1天内,2天内,3天内，7-30天）的入场记录
     */
    private Integer relLastenterRange;

    /**
     * 欠费车辆出口补缴开关 0:关闭 1:开启 默认0
     */
    private Integer exitpayType;

    /**
     * 出场前需补缴N（1-30）天有欠费订单
     */
    private Integer exitpayRangeDay;
    private Integer notpayTagDays;

    /**
     * 新能源优惠时长(分钟) 0代表不优惠;
     */
    private Integer newEnergyDiscountMinutes;

}
