package com.icetech.cloudcenter.domain.request.p2r;

import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.ToolsUtil;
import com.icetech.cloudcenter.domain.constants.SayElementConstants;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author fangct
 * 5.1.	屏显语音信息下发接口
 */
@Data
public class RobotHintRequest implements Serializable {
    private	String	plateNum	;
    private	String	say	;
    private	String	show	;

    /**
     * 兼容两行内容显示
     * @param show
     */
    public void setShow(String show){
        if (StringUtils.isNotBlank(show)){
            if (show.endsWith("/")) {
                show = show + " ";
            }
            String[] splitArr = show.split("/");
            if (splitArr.length == 1){
                show += "/ / / ";
            }else if (splitArr.length == 2){
                show += "/ / ";
            }else if (splitArr.length == 3){
                show += "/ ";
            }
            show = show.replace("//", "/ /");
        }
        this.show = show;
    }
    /**
     * 兼容两行内容显示
     * @param say
     */
    public void setSay(String say){
        //如果语音播报内容包含动态内容，需要转换
        if (StringUtils.isNotBlank(say) && say.contains("<")){
            String content = say.trim();
            StringBuffer sayStrBuf = new StringBuffer();
            int fromIndex = 0;
            int start = content.indexOf("<", fromIndex);
            while (start >= 0){
                int end = content.indexOf(">", start);
                String elementName = content.substring(start + 1, end);
                fromIndex = end;
                if (elementName.trim().length() > 0){
                    String template = SayElementConstants.SAY_ELEMENT.get(elementName.replace("/", ""));
                    if (template != null){

                        if (elementName.startsWith("/")){
                            //动态内容的结束标识
                        }else if (elementName.endsWith("/")){
                            //没有动态变量的标识
                            sayStrBuf.append(template);
                        }else{
                            //动态内容的开始标识
                            int start2 = content.indexOf("<", fromIndex);
                            fromIndex = start2 + 1;
                            String val = content.substring(end + 1, start2);
                            if (elementName.equals("D8")){
                                val = "1".equals(val) ? "小型车" : "大型车";
                            }else if (elementName.equals("D6") || elementName.equals("7")){
                                val = DateTools.secondToSecondsTime(Integer.parseInt(val));
                            }else if (elementName.equals("D7") || elementName.equals("8")){
                                val = new BigDecimal(val).divide(new BigDecimal(10)).setScale(2, BigDecimal.ROUND_HALF_DOWN).toString();
                            }
                            sayStrBuf.append(template.replace("%", val));
                        }
                    }
                }
                start = content.indexOf("<", fromIndex);
                sayStrBuf.append(" ");
            }
            this.say = sayStrBuf.toString().trim();
        }else{
            this.say = say;
        }
    }

}
