package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.util.List;


@Data
public class VipTypeRequest extends Request {
    /**
     * 操作类型1=添加 2=修改 3=删除
     */
    protected Integer operType;
    /**
     * VIP车辆类型ID
     */
    protected Integer vipTypeId;
    /**
     * VIP车辆类型名称
     */
    protected String vipTypeName = "";
    /**
     * 优惠类型
     */
    protected Integer discountType = -1;
    /**
     * 优惠数额
     */
    protected Integer discountNumber = -1;
    /**
     * 计费规则编号
     */
    protected String billtypecode = "";
    protected List<BillInfo> billInfo;
    /**
     * 计费信息，IOT时下发
     */
    protected String billInfoStr = "[]";

    @Getter
    @Setter
    @ToString
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class BillInfo {
        private Long regionId;
        private String billtypecode = "";
        private Integer regionType;
    }

    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本9.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_406, "当前相机版本号过低，无法下发，请升级");
        }
        return this;
    }
}
