package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * VIP信息
 */
@ToString
@Setter
@Getter
public class VipInfoRequest extends Request implements Serializable{

    private Long vipId;
    private Long vipTypeId;
    private String vipTypeName = "";
    private String plateNum = "";
    private String phone = "";
    private String startDate="";
    private String endDate="";
    private Integer discountType = 1;
    private Integer discountNumber = 0;
    private String billtypecode = "";

    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本4.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_407, "相机版本过低，暂不需要下发VIP");
        }
        if (P2cVersionEnum.版本9.getIndex() > P2cVersionEnum.getIndex(version)){
            if (discountType != 1){
                throw new ResponseBodyException(CodeConstants.ERROR_407, "相机版本过低，不支持下发非全免VIP");
            }
        }
        if (P2cVersionEnum.版本9.getIndex() > P2cVersionEnum.getIndex(version)){
            this.setVipTypeName("");
            this.setDiscountType(0);
            this.setDiscountNumber(0);
            this.setBilltypecode("");
        }
        return this;
    }
}
