package com.icetech.cloudcenter.domain.request.p2c;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 端云架构软触发参数类
 */
@ToString
@Setter
@Getter
public class SoftTriggerRequest implements Serializable{

    private String triggerNo;

    public enum ExtraInfoEnum {
        //移动端查询费用
        ALLOW_ENTER("allowEnter"),
        ALLOW_EXIT("allowExit"),
        GET_CAR_INFO("getCarInfo"),
        EXCEPTION_EXIT("exceptionExit"),
        CALL_VOICE_REPORT("callVoiceReport"),
        SWITCH_SNAP("switchSnap"),
        ;
        public String val;
        ExtraInfoEnum(String val){
            this.val = val;
        }
    }

    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class AllowEnter<T> extends SoftTriggerRequest {
        private String biz;
        private String plateNum;
        private Integer type;
        private String remark;
        private T requestVO;
    }
    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class AllowExit<T> extends SoftTriggerRequest {
        private String biz;
        private Integer type;
        private T requestVO;
    }
    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class GetCarInfo extends SoftTriggerRequest {
        private String biz;
        private Integer type;
        private String channelCode;
    }
    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class ExceptionExit extends SoftTriggerRequest {
        private String biz;
        private Integer type;
        private String  orderNum;
        private String plateNum;
        private Integer reasonType;
        private String operAccount;
        private Integer exitTerminal;
    }
    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class CallVoiceReport extends SoftTriggerRequest {
        private String biz;
        private String plateNum;
        private Integer type;
        private String orderNum;
        private String code;
        private String msg;
    }
    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class SwitchSnap extends SoftTriggerRequest {
        private String biz;
        /**
         * 开关闸记录表ID
         */
        private Integer id;
    }
}
