package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.common.annotation.NotNull;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

@Setter
@Getter
@ToString
public class LedsoundConfigRequest extends Request implements Serializable{

    @NotNull
    private Integer ledcardType;
    @NotNull
    private Integer supportTTS;
    //显示风格，1：横屏，2：竖屏，默认为1
    private Integer style = 1;
    private Integer ledRemainDaysMc;
    @NotNull
    private Integer ledExpireDaysMc;
    @Deprecated
    private Integer isExpireMc;
    @NotNull
    private Integer ledRestoreDefaultTime;
    @NotNull
    private Integer volumeValue;
    @NotNull
    private Integer quietHoursSwitch;
    private String quietStartTime;
    private String quietEndTime;
    private Integer quietVolumeValue;
    private Integer limitType;
    private String limitDriveNum1;
    private String limitDriveNum2;
    private String limitDriveNum3;
    private String limitDriveNum4;
    private String limitDriveNum5;
    private String parkName;
    private Integer freeSpace;
    @NotNull
    private String freePerLineColor;
    @NotNull
    private String busyPerLineColor;
    /**
     * @deprecated 使用 {@link #freePerLineColor}
     */
    @Deprecated
    private String freePerLineColorExit;    // 下发时置空
    /**
     * @deprecated 使用 {@link #busyPerLineColor}
     */
    @Deprecated
    private String busyPerLineColorExit;    // 下发时置空
    /**
     * @deprecated 使用 {@link #freePerLineColor}
     */
    @Deprecated
    private String freePerLineColorEnter;   // 下发时置空
    /**
     * @deprecated 使用 {@link #busyPerLineColor}    // 下发时置空
     */
    @Deprecated
    private String busyPerLineColorEnter;
    private Integer ledQrcodeRule;
    private String dynamicQR;

    //since V1.5.1
    private Integer realFreeSpace;
    private Integer totalSpace;
    private Integer showLanguage;
    private Integer voiceLanguage;

    @NotNull
    private List<LedConfig> ledConfig;
    @NotNull
    private List<SoundConfig> soundConfig;

    public void setLedQrcodeRule(Integer ledQrcodeRule){
        if (ledQrcodeRule == null){
            ledQrcodeRule = 0;
        }
        this.ledQrcodeRule = ledQrcodeRule;
    }
    public Integer getLedQrcodeRule(){
        if (this.ledQrcodeRule == null){
            return 0;
        }
        return this.ledQrcodeRule;
    }

    @Setter
    @Getter
    @ToString
    public static class LedConfig implements Serializable{
        @NotNull
        private Integer showScene;
        @NotNull
        private String content;
    }
    @Setter
    @Getter
    @ToString
    public static class SoundConfig implements Serializable{
        @NotNull
        private Integer sayScene;
        @NotNull
        private String content;
    }
    public enum SceneEnum {
        月卡车入场(1), 其他允许的入场(2), 月卡车离场(3), 其他无需缴费的离场(4), 入口空闲显示(5), 出口空闲显示(6),
        临时车入场不允许临时车进(7), 黑名单车辆入场(8), 其他不允许入场的车辆(9), 多位多车入场车位占用(10),
        入场月卡过期(11), 黑名单车出场(12), 无牌车出场(13), 出场需缴费(14), 出场无入场记录(15), 入场虚假车牌(16), 出场虚假车牌(17),
        ;
        public int scene;
        private SceneEnum(int scene){
            this.scene = scene;
        }
    }

    /**
     * 根据版本号重新构建参数
     * @param version
     * @return
     */
    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本3.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_407, "当前相机版本号过低，无法下发，请升级");
        }
        if (P2cVersionEnum.版本3.getVersion().equals(version)){
            int size1 = this.ledConfig.size();
            int size2 = this.soundConfig.size();
            if (size1 > 6){
                this.ledConfig.removeIf(next -> next.getShowScene() > 6);
            }
            if (size2 > 4){
                this.soundConfig.removeIf(next -> next.getSayScene() > 4);
            }
        }
        if (P2cVersionEnum.版本9.getIndex() <= P2cVersionEnum.getIndex(version)){
            this.setIsExpireMc(null);
        }
        //todo fix
        if (P2cVersionEnum.版本16.getIndex() == P2cVersionEnum.getIndex(version)){
            this.setLedcardType(3);
        }
        if (P2cVersionEnum.版本18.getIndex() > P2cVersionEnum.getIndex(version)){
            this.ledConfig.removeIf(next -> next.getShowScene() > 15);
            this.soundConfig.removeIf(next -> next.getSayScene() > 15);
        }
        return this;
    }
}

