package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.common.utils.StringUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 端云架构语音显示参数类
 */
@ToString
@Setter
@Getter
public class HintRequest implements Serializable {

    private String plateNum;
    private String show;
    private String say;
    private Integer showType = 1;
    private String extendShow = "";

    public void setShowTypeByShow(String show) {
        /*
         * 二维码显示设置
         */
        if (show != null && StringUtils.containsAny(show, "http://", "https://")){
            if (show.contains("|")){
                this.showType = 3;
            } else {
                this.showType = 2;
            }
        }
    }
}
