package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 端云架构-完整订单补报接口参数类
 */
@ToString
@Setter
@Getter
public class CompleteOrderRequest implements Serializable {

    private String orderNum;
    @NotNull
    private String plateNum;
    private Long enterTime;
    private Long exitTime;
    @NotNull
    private Integer triggerType;
    private String plateColor;
    private String carBrand;
    private String carColor;
    private Integer carType;
    private Integer shamFlag;
    private Integer reliability;
    private Integer type;
    private String exitSmallImage;
    private String exitMaxImage;
    private Integer paidAmountFen;
    private Integer discountAmountFen;
    private Integer payChannel;
    private String keyCode;

    /**
     * 辅助参数
     */
    //出入口名称
    private String inandoutName;
    private String inandoutCode;
    private String parkCode;
    private Long parkId;
    //异常离场时使用
    private boolean isException;
    private String totalAmount;
    private String paidAmount;
    private String discountAmount;
}
