package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 端云架构-在场车辆清除请求参数类
 * @author fangct
 */
@ToString
@Setter
@Getter
public class ClearInparkRequest extends Request implements Serializable {

    private String orderNum;

    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本4.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_407, "当前相机版本号过低，无法下发，请升级");
        }
        return this;
    }
}
