package com.icetech.cloudcenter.domain.request.itc;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 属性上报接口
 */
@ToString
@Setter
@Getter
public class PropertyInfoRequest implements Serializable {

    @NotNull
    private Integer enexType;
    @NotNull
    private String deviceIp;
    @NotNull
    private Long tzDiffSec;
    @NotNull
    private String version;
    /**
     * 产品型号
     */
    @NotNull
    private String productModel;
    /**
     * 固件版本号
     */
    @NotNull
    private String firmwareVersion;
    /**
     * 网络连接方式，1:无线，2:有线
     */
    private Integer connectionMode;
    /**
     * 无线网络运营商，1:移动，2:电信，3：联通，99：未知
     */
    private Integer wirelessCarrier;
    /**
     * 第几代无线网，例：5G、4G、3G、2G
     */
    private String network;
    /**
     * 滞留算法开关，0：关，1：开
     */
    private String retentionAlarm;
    /**
     * 滞留时间阈值，单位秒，范围在30到600，滞留算法开关为1开时生效
     */
    private String retentionTimeThreshold;


}
