package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 请求语音播报
 * @author wangzw
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class VoiceReportRequest implements Serializable {

    /**
     *车场编号
     */
    @NotNull
    private String parkCode;
    /**
     *通道编号
     */
    @NotNull
    private String aisleCode;
    /**
     *车牌号码
     */
    @NotNull
    private String plateNum;
    /**
     *订单号码
     */
    @NotNull
    private String orderNum;

    /**
     * 费用
     */
    @NotNull
    private String fee;
    /**
     * 停车时长
     */
    @NotNull
    private Long parkTime;
    private String topic;
    private String operAccount;
    private Integer exitTerminal;
    private Integer exitWay;
    private boolean hasNotPay;
    private List<String> orderNums;
}
