package com.icetech.cloudcenter.domain.request;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@Setter
@Getter
@ToString
public class QueryOrderFeeRequest implements Serializable {
    /**
     * 参数定义1
     */
    //车场编号
    private String parkCode;
    //车牌号
    private String plateNum;
    //通道ID
    private String channelId;
    //车型
    private Integer carType;

    /**
     * 参数定义2
     */
    //订单编号
    private String orderNum;
    //离场时间（计费截止时间）
    private Long exitTime;
    /**
     * 异步回调的topic
     */
    private String topic;
    /**
     * 扩展埋参
     */
    private String extraInfo;
    private Boolean isOffline;
    private Boolean withNotPay;
    /**
     * 入口/出口查询欠费
     */
    private Integer exType;
}
