package com.icetech.cloudcenter.domain.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2021-08-27 14:29
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class QueryOrderFeeDTO implements Serializable {

    public static final String EXIT_PAY = "1";

    public static final String ENTER_PAY = "2";

    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 通道编号
     */
    private String channelId;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 支付方式
     */
    private Integer payWay;
    /**
     * 唯一标识
     */
    private String openId;
    /**
     * 唯一标识
     */
    private String userId;

    /**
     * 下单ip
     */
    private String spbillCreateIp;
    /**
     * 1无牌车 2有牌车
     */
    private String type;
    /**
     * 1为出口支付 2为入口支付 //默认0
     */
    private String exit = "0";
    /**
     * 支付渠道
     */
    private Integer payChannel;
    /**
     * 缴费终端
     */
    private String payTerminal;

    /**
     * 公众号支付的用户
     */
    private Integer mpUserId;
}
