package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 开闸请求
 * @author wangzw
 */
@Data
public class OpenBrakeRequest implements Serializable {
    /**
     *车场编号
     */
    @NotNull
    private String parkCode;
    /**
     *通道编号
     */
    @NotNull
    private String aisleCode;
    /**
     * 记录类型，1：入，2：出
     */
    @NotNull
    private Integer recordType;
    /**
     * 开闸原因类型
     */
    @NotNull
    private Integer reasonType;
    /**
     *车牌号码
     */
    private String plateNum;
    /**
     * 订单号
     */
    private String orderNum;

    private Integer exitWay;
    private String operAccount;
    private String topic;
    private Integer exitTerminal;
    private String remark;
}

