package com.icetech.cloudcenter.domain.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Description ManagerInOutRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/7/21 4:18 下午
 */
@Data
public class ManagerInOutRequest implements Serializable {

    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 设备类型
     */
    private List<Integer> deviceType;

    /**
     * 出入口类型，1入口 2出口
     */
    private List<Integer> inandoutType;

    /**
     * 分页参数 页码
     */
    private Integer pageNo = 1;

    /**
     * 分页参数 页数
     */
    private Integer pageSize = 20;
    /**
     * 报警开始时间: yyyy-MM-dd HH:mm
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm",timezone = "GMT+8")
    private Date startTime;
    /**
     * 报警结束时间: yyyy-MM-dd HH:mm
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm",timezone = "GMT+8")
    private Date endTime;
}
