package com.icetech.cloudcenter.domain.request;

import com.icetech.cloudcenter.domain.response.QueryFeeRegionDetail;
import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

@Getter
@Setter
public class ExitCommonRequest implements Serializable{
    @NotNull
    private Long parkId;
    @NotNull
    private String orderId;
    @NotNull
    private String plateNum;
    @NotNull
    private Long exitTime;
    private String exitImage;
    @NotNull
    private String totalAmount;
    @NotNull
    private String paidAmount;
    @NotNull
    private String discountAmount;
    private String userAccount;
    @NotNull
    private Integer type;
    @NotNull
    private Integer carType;

    //add by hazard at 20190823
    private Integer isExceptionExit;
    private Integer exceptionReason;
    /**
     * 储值卡扣除金额
     */
    private Double balancePrice;
    private String remark;

    private List<PaidInfo> paidInfo;

    /**
     * 操作员/收费员
     */
    private String operAccount;
    /**
     * 欠费订单标识，1：欠费，0：未欠费，默认为0
     */
    private Integer notPayStatus;

    /**
     * 欠费订单应收金额，单位元
     */
    private String notPayTotalPrice;

    /**
     * 欠费订单优惠金额，单位元
     */
    private String notPayDiscountPrice;

    /**
     * 欠费订单需支付金额，单位元
     */
    private String notPayUnpayPrice;
    private String outChannelId;
    private String channelId;
    private Integer exTerminal;

    /**
     * 补缴通道id
     */
    private String payChannelId;

    public void setExitTime(Long exitTime) {
        if (exitTime != null && exitTime == -1){
            this.exitTime = null;
        }else{
            this.exitTime = exitTime;
        }
    }

    @Getter
    @Setter
    public static class PaidInfo implements Serializable {
        @NotNull
        private String tradeNo;
        @NotNull
        private String totalPrice;
        @NotNull
        private String paidPrice;
        @NotNull
        private String discountPrice;
        @NotNull
        private Integer payWay;
        @NotNull
        private Integer payChannel;
        private String payTerminal;
        @NotNull
        private Long payTime;
        private String userAccount;
        private String actualCash;
        private String redpackRet;
        /**
         * 银行单号
         */
        private String bankOrderId;

        /**
         * 商户单号
         */
        private String thirdTradeNo;
        private List<DiscountInfo> discountInfo;
        /**商家优惠金额**/
        private String merchantDiscountPrice;
         /**VIP优惠金额**/
        private String vipDiscountPrice;
         /**VIP类型ID**/
        private List<Integer> vipTypeId;
         /**第三方优惠金额**/
        private String thirdDiscountPrice;
         /**商家优惠金额**/
        private String tollDiscountPrice;
        /**
         * 储值卡扣除金额
         */
        private Double balancePrice;
        /**
         * 内区域缴费信息
         */
        private List<QueryFeeRegionDetail> regionDetails;

        /**
         * 补缴类型，0：正常 1：补缴
         */
        private Integer payType;

        @Override
        public String toString() {
            return "PaidInfo{" +
                    "tradeNo='" + tradeNo + '\'' +
                    ", totalPrice='" + totalPrice + '\'' +
                    ", paidPrice='" + paidPrice + '\'' +
                    ", discountPrice='" + discountPrice + '\'' +
                    ", payWay=" + payWay +
                    ", payChannel=" + payChannel +
                    ", payTerminal='" + payTerminal + '\'' +
                    ", payTime=" + payTime +
                    ", discountInfo=" + discountInfo +
                    ", merchantDiscountPrice=" + merchantDiscountPrice +
                    ", vipDiscountPrice=" + vipDiscountPrice +
                    ", vipTypeId=" + vipTypeId +
                    ", thirdDiscountPrice=" + thirdDiscountPrice +
                    ", tollDiscountPrice=" + tollDiscountPrice +
                    '}';
        }
    }

    @Getter
    @Setter
    public static class DiscountInfo implements Serializable {
        @NotNull
        private String discountNo;
        @NotNull
        private Integer discountType;
        @NotNull
        private String discountNumber;
        @NotNull
        private Integer discountTime;

        @Override
        public String toString() {
            return "DiscountInfo{" +
                    "discountNo='" + discountNo + '\'' +
                    ", discountType=" + discountType +
                    ", discountNumber='" + discountNumber + '\'' +
                    ", discountTime=" + discountTime +
                    '}';
        }
    }
}
