package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 入场测试
 * @author fangct
 */
@Data
public class EnterDebugRequest implements Serializable {
    /**
     *车场编号
     */
    @NotNull
    private String parkCode;
    /**
     *通道编号
     */
    @NotNull
    private String aisleCode;
    /**
     * 车牌号
     */
    @NotNull
    private String plateNum;
    /**
     * 入场时间
     */
    @NotNull
    private Long enterTime;
    /**
     * 车辆类型，1临时车2月卡车3特殊车辆 4 VIP车 5黑名单
     */
    @NotNull
    private Integer type;
    /**
     * 是否开闸，0：否，1：是
     */
    @NotNull
    private Integer isOpen;
}

